/**
 * 
 */
package gov.va.med.mhv.liferay.saml.binding.impl;

import org.apache.commons.httpclient.HttpClient;
import org.opensaml.common.binding.decoding.URIComparator;
import org.opensaml.saml2.binding.decoding.HTTPSOAP11Decoder;
import org.opensaml.xml.parse.ParserPool;

import com.liferay.saml.binding.impl.HttpSoap11Binding;

import gov.va.med.mhv.liferay.saml.binding.decoding.MhvCustomURIComparator;

/**
 * @author DNS
 *
 */
public class MhvHttpSoap11Binding extends HttpSoap11Binding {

	public MhvHttpSoap11Binding(ParserPool parserPool, HttpClient httpClient) {
		super(parserPool, httpClient);
		
		HTTPSOAP11Decoder messageDecoder = (HTTPSOAP11Decoder)this.getMessageDecoder();
		messageDecoder.setURIComparator(new MhvCustomURIComparator());
	}
	
	public MhvHttpSoap11Binding(ParserPool parserPool, HttpClient httpClient, URIComparator uriComparator) {
		super(parserPool, httpClient);
		
		HTTPSOAP11Decoder messageDecoder = (HTTPSOAP11Decoder)this.getMessageDecoder();
		messageDecoder.setURIComparator(uriComparator);
	}
	
}
